{ Ejemplo de utilizacin de Google Maps en Delphi.
  by  Neftal  -Germn Estvez-  2009
  http://neftali.clubdelphi.com

  NOTA: Este ejemplo y su cdigo es de libre distribucin. Si te es de utilidad,
  tienes sugerencias, comentarios o errores puedes escribirlos en mi web.
  Todos ellos sern bienvenidos.  ;-D
  http://neftali.clubdelphi.com

  NOTE: This sampole and its code is freely distributed. If you are useful,
   have suggestions, comments or errors can post it to my website.
   All of them are welcome. ;-D
   http://neftali.clubdelphi.com
}

unit FOpciones;

//=========================================================================
//
// I N T E R F A C E
//
//=========================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ComCtrls, ExtCtrls, CheckLst, Buttons, ActnList;

type
  TFormOpciones = class(TForm)
    pc: TPageControl;
    tsPOsicion: TTabSheet;
    tsOpciones: TTabSheet;
    lbl1: TLabel;
    seAlto: TSpinEdit;
    seAncho: TSpinEdit;
    lbl2: TLabel;
    clControls: TCheckListBox;
    rgTipoMapa: TRadioGroup;
    grpMArca: TGroupBox;
    pnlBotones: TPanel;
    btnAplicar: TBitBtn;
    chkMArca: TCheckBox;
    lblLon: TLabel;
    lblLat: TLabel;
    edtLat: TEdit;
    edtLon: TEdit;
    ActionList1: TActionList;
    ActionAplicar: TAction;
    procedure FormShow(Sender: TObject);
    procedure ActionAplicarExecute(Sender: TObject);
  private
    { Private declarations }
  public
    procedure SetMapControl(StrControl:string; Active:Boolean);
  end;

var
  FormOpciones: TFormOpciones;


// Controles
{
GLargeMapControl
GSmallMapControl
GSmallZoomControl
GScaleControl
GMapTypeControl
GHierarchicalMapTypeControl
GOverviewMapControl
}


// Tipos de mapas
{
G_NORMAL_MAP
G_SATELLITE_MAP
G_HYBRID_MAP
G_PHYSICAL_MAP
}


//=========================================================================
//
// I M P L E M E N T A T I O N
//
//=========================================================================
implementation

uses FMapa;

{$R *.dfm}

procedure TFormOpciones.FormShow(Sender: TObject);
begin
  // Ini
  pc.ActivePageIndex := 0;

  // Posicion
  Self.Left :=  FormMapa.Left + FormMapa.Width;
  Self.Top :=  FormMapa.Top;
end;

procedure TFormOpciones.SetMapControl(StrControl: string; Active: Boolean);
var
  i:Integer;
begin
  i := clControls.Items.IndexOf(StrControl);
  if (i <> -1) then begin
    clControls.Checked[i] := Active;
  end;
end;

procedure TFormOpciones.ActionAplicarExecute(Sender: TObject);
var
  k, count:Integer;
  arr:TArrString;
  StrTipo:string;
begin

  // ini
  count := 0;

  // Aadir
  for k := 0 to (clControls.Items.Count - 1) do begin
    /// Activo
    if (clControls.Checked[k]) then begin
      count := count + 1;
      SetLength(arr, count);
      arr[count - 1] := clControls.Items[k];
    end;
  end;

  // Esta desactivada
  FormOpciones.SetMapControl('GHierarchicalMapTypeControl', False);

  // Recargar el mapa
  StrTipo := rgTipoMapa.Items[rgTipoMapa.ItemIndex];
  FormMapa.LoadMapa(seAlto.Value, seAncho.Value, arr,
                    chkMarca.Checked,
                    edtLat.Text, edtLon.Text,
                    StrTipo);

  // Posicion
  Self.Left :=  FormMapa.Left + FormMapa.Width;
  Self.Top :=  FormMapa.Top;

end;

end.
